#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

from OSEHRAHelper import PROMPT

#---------------------------------------------------------------------------
# Open FileMan and start by creating the VistA Health Care institution
#---------------------------------------------------------------------------
def AddOneInstitution(VistA,institutionname,shortname,stationnumber,typecode,NPI,multidivision,facilitytype,street,street2,city,state,zip,phone,domain):
  VistA.write('S DUZ=1 S XUMF=1 D Q^DI')
  VistA.wait('OPTION:')
  VistA.write('1')
  VistA.wait('INPUT TO WHAT FILE:')
  VistA.write('4')
  VistA.wait('EDIT WHICH FIELD')
  VistA.write('')
  VistA.wait('Select INSTITUTION NAME:')
  VistA.write(institutionname)
  VistA.wait('Are you adding')
  VistA.write('Y')
  VistA.wait('STATE')
  VistA.write(state)
  VistA.wait('DISTRICT')
  VistA.write('')
  VistA.wait('SHORT NAME')
  VistA.write(shortname)
  VistA.wait('VA TYPE CODE')
  VistA.write(typecode)
  VistA.wait('REGION')
  VistA.write('')
  VistA.wait('STREET ADDR. 1')
  VistA.write(street)
  VistA.wait('STREET ADDR. 2')
  VistA.write(street2)
  VistA.wait('CITY')
  VistA.write(city)
  VistA.wait('ZIP')
  VistA.write(zip)
  VistA.wait('Select CONTACT')
  VistA.write('MAIN\rY')
  VistA.wait('AREA')
  VistA.write('')
  VistA.wait('PHONE #')
  VistA.write(phone)
  VistA.wait('Select CONTACT')
  VistA.write('')
  VistA.wait('ST. ADDR. 1')
  VistA.write(street)
  VistA.wait('ST. ADDR. 2')
  VistA.write('')
  VistA.wait('CITY')
  VistA.write(city)
  VistA.wait('STATE')
  VistA.write(state)
  VistA.wait('ZIP')
  VistA.write(zip)
  VistA.wait('MULTI-DIVISION FACILITY')
  VistA.write(multidivision)
  VistA.wait('STATUS')
  VistA.write('N')
  VistA.wait('FACILITY TYPE')
  VistA.write(facilitytype)
  VistA.wait('Select ASSOCIATIONS')
  VistA.write('2')
  VistA.wait('Are you adding')
  VistA.write('Y')
  VistA.wait('PARENT OF ASSOCIATION')
  VistA.write(institutionname)
  VistA.wait('NPI')
  VistA.write(NPI)
  VistA.wait('Select EFFECTIVE DATE/TIME')
  VistA.write('T')
  VistA.wait('Are you adding')
  VistA.write('Y')
  VistA.wait('STATUS')
  VistA.write('1')
  VistA.wait('NPI')
  VistA.write(NPI)
  VistA.wait('TAXONOMY CODE')
  VistA.write('')
  VistA.wait('ACOS HOSPITAL ID')
  VistA.write('')
  VistA.wait('FACILITY DEA NUMBER')
  VistA.write('')
  VistA.wait('DOMAIN')
  VistA.write(domain)
  VistA.wait('AGENCY CODE')
  VistA.write('VA')
  VistA.wait('REPORTING STATION')
  VistA.write('')
  VistA.wait('POINTER TO AGENCY')
  VistA.write('VA')
  VistA.wait('STATION NUMBER:')
  VistA.write(stationnumber)
  OptionalList = ['OFFICIAL VA NAME',
                  'INACTIVE FACILITY FLAG',
                  'BILLING FACILITY NAME',
                  'CURRENT LOCATION',
                  'Select EFFECTIVE DATE',
                  'Select CODING SYSTEM',
                  # special treatment section
                  'Select NAME:',
                  'Select INSTITUTION NAME:']
  while True:
    index = VistA.multiwait(OptionalList)
    if index == len(OptionalList) - 2: # assicoate name
      VistA.write("VAHS")
      VistA.wait('//')
      VistA.write('Y')
      VistA.wait('NAME NUMBER:')
      VistA.write('')
    else:
      VistA.write('')
    if index == len(OptionalList) - 1:
      break
  VistA.wait('Select OPTION')
  VistA.write('')

